function [ Y, Phi, P, options ] = UEUplinkPilotTransmission( G, H_d, H_r, options )
%UEUPLINKPILOTTRANSMISSIOMN Summary of this function goes here
%   Detailed explanation goes here

Phi = zeros(options.N,options.N_slot);
%% allocate the reflection coefficients
if (options.N_slot == (options.N+1))
    F = dftmtx(options.N+1);
    Phi = F(2:options.N+1,:);
elseif (options.N_slot == ceil(options.N/options.M)+1)
    Phi(:,1) = exp(1i*2*pi*rand(options.N,1));
    for i = 2:options.N_slot
        for j = 1:ceil(options.N/options.M)
            range_l = options.M*(j-1)+1;
            range_r = min([options.M*j, options.N]);
            Phi(range_l:range_r,i) = Phi(range_l:range_r,1)*exp(1i*2*pi*(i-1)*j/options.N_slot);
        end
    end
else
%     Phi = exp(1i*2*pi*rand(options.N,options.N_slot));
%     Phi = exp(1i*pi*randi(2,options.N,options.N_slot));
end

%% uplink pilot transmission
Y = zeros(options.M, options.N_slot, options.K);
P = dftmtx(options.K);
for n = 1:options.N_slot
    for u = 1:options.K
        Y(:, n, u) = (H_d+G*diag(Phi(:,n))*H_r)*P(:,u)*sqrt(options.Tx_power) + (normrnd(0,1,options.M,1) + 1i*normrnd(0,1,options.M,1))*sqrt(options.noise_var/2);
    end
end

end

